﻿using System;
using System.Data.Common;
using System.Data.SqlClient;

namespace BasicAdoNet
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 14-1. Podstawowy dostęp do danych przy użyciu mechanizmu ADO.NET
            string sqlConnectionString = @"Data Source=.\sqlexpress;" +
                "Initial Catalog=AdventureWorksLT2008;Integrated Security=True";
            string state = "California";
            using (DbConnection conn = new SqlConnection(sqlConnectionString))
            using (DbCommand cmd = conn.CreateCommand())
            {
                cmd.CommandText =
                    "SELECT AddressLine1, AddressLine2, City FROM SalesLT.Address WHERE " +
                    "StateProvince=@state";
                DbParameter stateParam = cmd.CreateParameter();
                stateParam.ParameterName = "@state";
                stateParam.Value = state;
                cmd.Parameters.Add(stateParam);

                conn.Open();
                using (DbDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        string addressLine1 = reader.GetString(0);
                        // W przypadku pola AddressLine2 dopuszcza się występowanie wartości pustej,
                        // dlatego należy się przygotować zarówno na otrzymanie łańcucha znakowego,
                        // jak i wartości DBNull.
                        string addressLine2 = reader.GetValue(1) as string;
                        string city = reader.GetString(2);

                        Console.WriteLine(addressLine1);
                        Console.WriteLine(addressLine2);
                        Console.WriteLine(city);
                    }
                }
            }
        }
    }
}
